<?php

if (!defined('IN_MYBB'))
    die(); //prevent direct access 
$plugins->add_hook("pre_output_page", "cnpl_display_panel");
$plugins->add_hook("global_end", "cnpl_add_stylesheet");

function cnpl_info() {

    return array(
        "name" => "هاك روابط الهيدر",
        "description" => "يقوم باضافة روابط اعلي الهيدر تستطيع التحكم بها بسهوله.",
        "website" => "http://mybb.com",
        "author" => "Desugrace",
        "authorsite" => "http://mybb.com",
        "version" => "1.0",
        "guid" => "17f02404ca136e3efd851e2bc89005b7",
        "compatibility" => "*"
    );
}

function cnpl_is_installed() {
    global $db; 
    $rows = $db->query("SELECT * FROM " . TABLE_PREFIX . "settings WHERE name LIKE '%cnpl_setting%' ");
    if ($db->num_rows($rows) > 0)
        return true; else
        return false;
}

function cnpl_install() {
    global $db;
//-----------------------------------------------------------------------------
    $setting_group = array(
        'gid' => 'NULL',
        'name' => 'Custom Navigation Links',
        'title' => 'هاك روابط الهيدر',
        'description' => 'اعدادات الهاك',
        'disporder' => "1",
        'isdefault' => 'no',
    );
    $db->insert_query('settinggroups', $setting_group);
    $gid = $db->insert_id();


    $cnpl__settings = array(
        'name' => 'cnpl_setting1',
        'title' => 'اضف الروابط او كود الهتميل',
        'description' => 'اضف روابط بهذا الشكل, الرابط الاول|http://link1.com, الرابط الثاني|http://link2.com  وافصل بينهم بفاصله او اضف كود هتميل.',
        'optionscode' => 'textarea', //this will be a textbox, for a big textbox use textarea
        'value' => 'الرابط الاول|http://link1.com, الرابط الثاني|http://link2.com',
        'disporder' => 3,
        'gid' => intval($gid),
    );

    $db->insert_query('settings', $cnpl__settings);

    $cnpl__settings2 = array(
        'name' => 'cnpl_setting2',
        'title' => 'تفعيل / تعطيل',
        'description' => 'تستطيع تفعيل او تعطيل الهاك من هنا',
        'optionscode' => 'yesno', //this will be a yes/no select box
        'value' => '1', //default value is yes, use 0 for no
        'disporder' => 1,
        'gid' => intval($gid),
    );
    $db->insert_query('settings', $cnpl__settings2);
 
    $cnpl__settings3 = array(
        'name' => 'cnpl_setting3',
        'title' => 'تفعيل الهتميل',
        'description' => 'ان اردت وضع اكواد هتميل قم بتفعيل هذا الخيار',
        'optionscode' => 'yesno', //this will be a yes/no select box
        'value' => '0', //default value is yes, use 0 for no
        'disporder' => 2,
        'gid' => intval($gid),
    );
    $db->insert_query('settings', $cnpl__settings3);

    rebuild_settings();
}

function cnpl_add_stylesheet() {
    global $headerinclude;
    $headerinclude.= '<link rel="stylesheet" href="inc/plugins/cnpl/css/style.css" type="text/css" />';
}

function cnpl_display_panel($conts) {
    global $mybb;
    $a = array();
    if ($mybb->settings['cnpl_setting2'] == '1' && $mybb->settings['cnpl_setting3'] == '0') {
        $links = explode(',', $mybb->settings['cnpl_setting1']);
        $links = array_map('trim', $links);
        foreach ($links as $link) {
            $li = explode('|', $link);
            $a[] = "<a  href='{$li[1]}'>{$li[0]}</a>  ";
        }
        if (sizeof($a) > 0) {
            $a = implode(' | ', $a);
            $conts = str_replace('<div id="container">', '<div id="container"><div id="custom_nav_panel">' . $a . '</div>', $conts);

            return $conts;
        }
    } else if ($mybb->settings['cnpl_setting2'] == '1' && $mybb->settings['cnpl_setting3'] == '1') {
        $conts = str_replace('<div id="container">', '<div id="container"><div id="custom_nav_panel">' . $mybb->settings['cnpl_setting1'] . '</div>', $conts);
        return $conts;
    }
}

function cnpl_uninstall() {
    global $db; 

    $db->delete_query("settinggroups", "`name` = 'Custom Navigation Links' ");
    $db->delete_query("settings", "`name` LIKE  '%cnpl_setting%' ");
}



?>
